_Assemble.vsh
{
	#if defined(CLIP)
		varying vec3	v_clipVertex;
	#endif
	varying vec4	color;
	include colorGen.inc
	include deforms.inc
	void main(void)
	{
		vec4 glVertex = DeformGeometry();
		color = colorGen(glVertex);
		gl_Position = gl_ModelViewProjectionMatrix * glVertex;
		include clipVertex.inc
	}
}

_Assemble.fsh
{
	#extension GL_ARB_texture_rectangle: enable
	uniform sampler2DRect	u_ColorBuffer;
	uniform sampler2DRect	u_SpecularBuffer;
	uniform float u_ambientScale;
	#if defined(CLIP)
		uniform vec4	u_clipPlane;
		varying vec3	v_clipVertex;
	#endif
	varying vec4	color;
	void main(void)
	{
		include clipPlane.inc
		if (texture2DRect(u_SpecularBuffer, gl_FragCoord.xy).a == 1.0)
		{
			discard;	// no portal surfaces draw
			return;
		}
		vec4 diffuse = texture2DRect(u_ColorBuffer, gl_FragCoord.xy);
		diffuse.rgb *= u_ambientScale;
		gl_FragColor = color * diffuse;
	}
}


_AmbientLight.vsh
{
	#if defined(CLIP)
		varying vec3	v_clipVertex;
	#endif
	include deforms.inc
	void main(void)
	{
		vec4 glVertex = DeformGeometry();
		gl_Position = gl_ModelViewProjectionMatrix * glVertex;
		include clipVertex.inc
	}
}

_AmbientLight.fsh
{
	#extension GL_ARB_texture_rectangle: enable
	uniform sampler2DRect	u_ColorBuffer;
	uniform sampler2DRect	u_SpecularBuffer;
	uniform sampler2DRect	u_LightDiffuseBuffer;
	uniform sampler2DRect	u_LightSpecularBuffer;
	#if defined(CLIP)
		uniform vec4	u_clipPlane;
		varying vec3	v_clipVertex;
	#endif
	void main(void)
	{
		include clipPlane.inc
		vec4 specular = texture2DRect(u_SpecularBuffer, gl_FragCoord.xy);
		if (specular.a == 1.0)
		{
			discard;
			return;
		}
		vec3 diffuse = texture2DRect(u_ColorBuffer, gl_FragCoord.xy).rgb;
		vec3 lightD = texture2DRect(u_LightDiffuseBuffer, gl_FragCoord.xy).rgb;
		vec3 lightS = texture2DRect(u_LightSpecularBuffer, gl_FragCoord.xy).rgb;
		gl_FragColor.rgb = lightD * diffuse + lightS * specular.rgb;
	}
}


_FBO2Screen.vsh
{
	void main(void)
	{
		gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;
	}
}

_FBO2Screen.fsh
{
	#extension GL_ARB_texture_rectangle: enable
	uniform sampler2DRect	u_ColorBuffer;
	void main(void)
	{
		gl_FragColor.rgb = texture2DRect(u_ColorBuffer, gl_FragCoord.xy).rgb;
	}
}
